# Entity Share

## Introduction

This module allows to share entities using the JSON:API. It provides a UI to
use the endpoints provided by the JSON:API module.

You can define one website as a "server" and another website as a "client". A
website can be both "client" and "server".

See also the documentation pages:
* [Supported field types](https://www.drupal.org/docs/contributed-modules/entity-share/supported-field-types)
* [Advanced usages](https://www.drupal.org/docs/contributed-modules/entity-share/advanced-usages)

## Requirements

This module requires the following module:
* JSON:API (Core)

## Recommended modules

* [JSON:API Extras](https://www.drupal.org/project/jsonapi_extras):
  To allow to customize the JSON:API endpoints and to enable full pager
  feature. See the documentation page
  [Supported field types](https://www.drupal.org/docs/contributed-modules/entity-share/supported-field-types).
* [Views Bulk Operations](https://www.drupal.org/project/views_bulk_operations):
  To allow to update the import policy without having to reimport entities.

## Installation

* Install and enable the Entity Share Server on the site you want to get
  content from.
* Install and enable the Entity Share Client on the site you want to put
  content on.

## Configuration

See the documentation pages:
* [Installation and configuration](https://www.drupal.org/docs/contributed-modules/entity-share/installation-and-configuration)
* [Authorization methods](https://www.drupal.org/docs/contributed-modules/entity-share/authorization-methods)

## Maintainers

* [Thomas Bernard (ithom)](https://www.drupal.org/user/3175403)
* [Florent Torregrosa (Grimreaper)](https://www.drupal.org/user/2388214)
* [Ivan Vujović (ivan.vujovic)](https://www.drupal.org/user/382945)
* [Yarik Lutsiuk (yarik.lutsiuk)](https://www.drupal.org/user/3212333)

This project has been sponsored by:
* [Smile](https://www.drupal.org/smile) -
  Sponsored initial development, evolutions, maintenance and support.
* [Lullabot](https://www.drupal.org/lullabot) -
  Sponsored development of new features in association with Carnegie Mellon
  University.
* [Carnegie Mellon University](https://www.drupal.org/carnegie-mellon-university)
* [Studi](https://www.studi.com) -
  Sponsored development of new features.
* [Actency](https://www.drupal.org/actency) - Sponsored maintenance time.
