<?php

namespace Drupal\update_status_button\Controller;

use Drupal\node\Entity\Node;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Drupal\Core\Url;

class StatusUpdateController {
    public function updateStatus($node) {
        $node = Node::load($node);

        if ($node->hasField('field_approve')) {
            $current_status = $node->get('field_approve')->value;
            // Toggle or update the field_status value
            if ($current_status == 1) {
                $new_status = 0;
            }
            elseif ($current_status == 0) {
                $new_status = 1;
            }

            $node->set('field_approve', $new_status);
            $node->save();
        }
    
        return new RedirectResponse(Url::fromRoute('entity.node.canonical', ['node' => $node->id()])->toString());
    }
}