<?php

namespace Drupal\custom_qr_code\Controller;


use Drupal\Core\Controller\ControllerBase;
use Drupal\node\Entity\Node;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Url;


class CustomQRCodeController extends ControllerBase {


    public function updateStatus($node, Request $request) {
        // Load the node entity by its ID.
        $node = Node::load($node);  
        $field_price = \Drupal::request()->request->get('field_price');

        // Check if the node exists and has the required fields.
        if (isset($field_price) && is_numeric($field_price)) {
            // Update field_used_bool to true.
            $node->set('field_used_bool', 1);

            // Set the current date to field_used.
            $current_date = date('Y-m-d');
            $node->set('field_used', $current_date);

            // Get user input for field_price from the request (assuming it's a POST request).
            $node->set('field_price', $field_price);
            $node->set('field_total', $field_price * $node->get('field_liter')->value);

            $node->set('field_no_pol', \Drupal::request()->request->get('field_nopol'));
            $node->set('field_km', \Drupal::request()->request->get('field_km'));


            // Save the updated node.
            $node->save();
        }

        // Redirect to the canonical page of the updated node.
        return new RedirectResponse(Url::fromRoute('entity.node.canonical', ['node' => $node->id()])->toString());
    }
}